# バッチ設計書 1-next build

## 概要

本ドキュメントは、Next.jsアプリケーションのプロダクションビルドを実行する `next build` コマンドのバッチ設計書である。CLIエントリポイントからビルドプロセス全体の処理フロー、入出力仕様、エラー処理を定義する。

### 本バッチの処理概要

`next build` は、Next.jsアプリケーションのソースコードをプロダクション環境向けにコンパイル・最適化し、デプロイ可能な成果物（`.next` ディレクトリ）を生成するバッチ処理である。

**業務上の目的・背景**：Next.jsアプリケーションを本番環境にデプロイするためには、ソースコードのコンパイル、バンドル最適化、静的ページの事前生成（Static Generation）、ルーティングマニフェストの生成等が必要である。本バッチはこれらの処理を一括で実行し、プロダクション品質の成果物を生成する。開発者がアプリケーションをデプロイ可能な状態にするための必須工程である。

**バッチの実行タイミング**：随時実行。開発者がデプロイ前にローカルまたはCI/CD環境で手動もしくは自動で実行する。デプロイパイプラインの一部として統合されることが一般的である。

**主要な処理内容**：
1. CLIオプションの解析とバンドラー（Turbopack/Webpack/Rspack）の選択
2. プロジェクトディレクトリの検証と環境変数の読み込み
3. next.config.js の読み込みと設定の解決
4. TypeScript型チェック（設定による）
5. ソースコードのコンパイルとバンドル生成
6. 静的ページの事前レンダリング（Static Generation / ISR）
7. ルーティングマニフェスト、ビルドマニフェスト等の各種マニフェストファイル生成
8. ビルドトレースの収集と出力
9. テレメトリデータの送信

**前後の処理との関連**：前提として `pnpm install` 等による依存関係のインストールが完了していること。後続処理として `next start` によるプロダクションサーバー起動、またはデプロイプラットフォームへのデプロイが行われる。モノレポ環境では `turbo run build` から呼び出されることがある。

**影響範囲**：プロジェクトの `.next` ディレクトリ（ビルド成果物）全体。静的アセット、サーバーバンドル、マニフェストファイル、プリレンダリングされたHTMLファイル等が生成・更新される。

## バッチ種別

ビルド処理（コンパイル・バンドル・静的生成）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js がインストールされていること |
| 依存関係インストール済み | `pnpm install` 等で依存パッケージがインストール済みであること |
| プロジェクトディレクトリ存在 | 指定されたディレクトリが存在すること |
| next.config設定ファイル | プロジェクトルートに next.config.js/ts/mjs が存在すること（省略可） |

### 実行可否判定

プロジェクトディレクトリの存在チェックを行い、存在しない場合はエラーメッセージを出力して終了する。`existsSync(dir)` による検証が行われる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| directory | string | No | カレントディレクトリ | プロジェクトルートディレクトリ |
| --turbopack / --turbo | boolean | No | false | Turbopackバンドラーを使用 |
| --webpack | boolean | No | false | Webpackバンドラーを使用 |
| --profile | boolean | No | false | プロファイリングを有効化 |
| --debug | boolean | No | false | デバッグモードを有効化 |
| --debug-prerender | boolean | No | false | プリレンダリングのデバッグモード |
| --no-mangling | boolean | No | false | マングリングを無効化（デバッグ用） |
| --experimental-app-only | boolean | No | false | App Routerのみビルド |
| --experimental-build-mode | string | No | "default" | ビルドモード（default/compile/generate/generate-env） |
| --experimental-upload-trace | string | No | なし | トレースアップロード先URL |
| --experimental-debug-memory-usage | boolean | No | false | メモリデバッグモード |
| --experimental-analyze | boolean | No | false | バンドル分析（Turbopackのみ） |
| --debug-build-paths | string | No | なし | 選択的ビルドパスの指定 |
| --experimental-cpu-prof | boolean | No | false | CPUプロファイリング |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| プロジェクトソースコード | TypeScript/JavaScript/JSX/TSX | App Router / Pages Router のソースファイル |
| next.config.js/ts/mjs | JavaScript/TypeScript | Next.js設定ファイル |
| .env / .env.local 等 | テキスト | 環境変数定義ファイル |
| package.json | JSON | プロジェクト依存関係定義 |
| tsconfig.json | JSON | TypeScript設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| .next/build-manifest.json | JSON | クライアントサイドビルドマニフェスト |
| .next/routes-manifest.json | JSON | ルーティングマニフェスト |
| .next/prerender-manifest.json | JSON | プリレンダリングマニフェスト |
| .next/server/ | ディレクトリ | サーバーサイドバンドル |
| .next/static/ | ディレクトリ | 静的アセット |
| .next/BUILD_ID | テキスト | ビルドID |
| .next/server/pages-manifest.json | JSON | ページマニフェスト |
| .next/server/middleware-manifest.json | JSON | ミドルウェアマニフェスト |
| .next/server/app-paths-manifest.json | JSON | App Routerパスマニフェスト |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各マニフェストは固定名 |
| 出力先 | プロジェクトルート/.next/ |
| 文字コード | UTF-8 |
| 区切り文字 | JSON形式 |

## 処理フロー

### 処理シーケンス

```
1. CLIオプション解析
   └─ NextBuildOptions型に基づくオプション解析、バンドラー選択
2. シグナルハンドラ登録
   └─ SIGTERM/SIGINT でCPUプロファイル保存と適切な終了コードで終了
3. プロジェクトディレクトリ検証
   └─ getProjectDir()でディレクトリ解決、existsSync()で存在チェック
4. 選択的ビルドパスの解決（オプション）
   └─ debugBuildPaths指定時、パターンからApp/Pagesパスを解決
5. ビルド実行（build関数呼び出し）
   └─ 設定読み込み、コンパイル、最適化、静的生成、マニフェスト生成
6. エラーハンドリング
   └─ 既知エラーコードの分類と適切なメッセージ出力
7. メモリデバッグモード終了処理
   └─ experimentalDebugMemoryUsage有効時のクリーンアップ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始: next build] --> B[CLIオプション解析]
    B --> C[バンドラー選択: Turbopack/Webpack/Rspack]
    C --> D{プロジェクトディレクトリ存在?}
    D -->|なし| E[エラー出力して終了]
    D -->|あり| F[環境変数・設定読み込み]
    F --> G[TypeScript型チェック]
    G --> H[ソースコードコンパイル・バンドル]
    H --> I[静的ページ事前生成]
    I --> J[マニフェストファイル生成]
    J --> K[ビルドトレース収集]
    K --> L{ビルド成功?}
    L -->|成功| M[テレメトリ送信]
    L -->|失敗| N[エラーコード分類・出力]
    M --> O[バッチ終了: 正常]
    N --> P[バッチ終了: 異常]
    E --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。ファイルシステムへの読み書きのみを実行する。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| INVALID_RESOLVE_ALIAS | ビルドエラー | resolveエイリアスの設定不正 | next.config.js のalias設定を確認 |
| WEBPACK_ERRORS | ビルドエラー | Webpackコンパイルエラー | ソースコードのエラーを修正 |
| BUILD_OPTIMIZATION_FAILED | 最適化エラー | ビルド最適化処理の失敗 | ビルドログを確認し原因を特定 |
| NEXT_EXPORT_ERROR | エクスポートエラー | 静的エクスポート失敗 | ページの動的依存を確認 |
| NEXT_STATIC_GEN_BAILOUT | 静的生成エラー | 静的生成のベイルアウト | 動的APIの使用箇所を確認 |
| EDGE_RUNTIME_UNSUPPORTED_API | ランタイムエラー | Edge RuntimeでサポートされないAPI使用 | サポートされるAPIに変更 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ機構なし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ビルド失敗時は、エラーメッセージとエラーコードがコンソールに出力される。開発者はエラーメッセージに従ってソースコードまたは設定を修正し、再度ビルドを実行する。`.next` ディレクトリを削除してクリーンビルドを試みることも有効である。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作のみ（DB トランザクションなし） |
| コミットタイミング | 各ファイル書き込み時 |
| ロールバック条件 | ビルド失敗時は不完全な.nextディレクトリが残る可能性あり |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | プロジェクトのページ数に依存（数ページ～数千ページ） |
| 目標処理時間 | プロジェクト規模に依存（小規模: 数十秒、大規模: 数分～数十分） |
| メモリ使用量上限 | Node.jsデフォルトヒープ（--max-old-space-sizeで変更可能） |

## 排他制御

同一プロジェクトディレクトリに対する同時ビルドは推奨されない。`.next` ディレクトリへの同時書き込みによりファイル破損の可能性がある。lockfilePatchPromise による SWC バインディングのロック機構が存在する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ビルド開始時 | ビルドモード、バンドラー種別、実験的機能の有効/無効 |
| 進捗ログ | コンパイル中 | コンパイルステップの進捗、型チェック結果 |
| 警告ログ | 設定検出時 | マングリング無効、プロファイリング有効等の警告 |
| 終了ログ | ビルド完了時 | ページ一覧のツリービュー表示、バンドルサイズ |
| エラーログ | エラー発生時 | エラーコード、エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ビルド時間 | プロジェクト依存 | CI/CDパイプラインの通知設定に依存 |
| 終了コード | 0以外 | CI/CDパイプラインの失敗通知 |

## 備考

- CLIエントリポイント: `packages/next/src/cli/next-build.ts`
- ビルドコア処理: `packages/next/src/build/index.ts`
- Turbopackビルド: `packages/next/src/build/turbopack-build.ts`
- Webpackビルド: `packages/next/src/build/webpack-build/index.ts`
- 環境変数 `NEXT_DEBUG_BUILD` を設定するとデバッグモードが有効になる
- 環境変数 `NEXT_TRACE_UPLOAD_DISABLED` でトレースアップロードを無効化可能
- 環境変数 `EXPERIMENTAL_DEBUG_MEMORY_USAGE` でメモリデバッグモードが有効になる
